/***************************************************************************
                           msg.cpp  -  description
                             -------------------

  Handles communication between clients and this server. Also processes
  messages, and calls gfx functions based on what the message is.

    begin                : Sun Sep  1 00:52:11 EDT 2002
    copyright            : (C) 2002 by Chris Haag
    email                : dragonslayer_developer@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winsock.h>
#endif
#ifdef unix
#include <pthread.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <memory.h>
#define closesocket(s) shutdown(s, 2)
#endif
#include <memory.h>
#include <stdlib.h>
#include "msg.h"
#include "gfx.h"
#include "mem.h"
#include "console.h"

#ifndef INVALID_SOCKET
#define INVALID_SOCKET -1
#endif
#ifndef SOCKET_ERROR
#define SOCKET_ERROR -1
#endif

int g_sListen = INVALID_SOCKET;
unsigned short g_wPort = GLAPPGRAPHERMSG_DEFAULT_PORT;

/* Thread used to communicate with a client */
/* TODO: Support data > 2048 bytes!!! */
#ifdef WIN32
DWORD WINAPI MessageThread(LPVOID lpParam)
#define THREAD_FAILED -1
#else
#ifdef unix
void* MessageThread(void* lpParam)
#define THREAD_FAILED (void*)-1
#endif
#endif
{
	int s = (int)lpParam;
	char szData[2048], szPendingData[2048], *pszPending = szPendingData, *pszData;
	int pendingsize = 8;
	int msg;
	int size;
	enum { eGettingMsg, eGettingData } status = eGettingMsg;

	if (s == INVALID_SOCKET)
		return THREAD_FAILED;

	/* Receive a complete message */
	while (SOCKET_ERROR != (size=recv(s, szData, 2048, 0)))
	{
		pszData = szData;
		while (size)
		{
			if (size < pendingsize)
			{
				memcpy(pszPending, szData, size);
				pszPending += size;
				pendingsize -= size;
				size = 0;
			}
			else
			{
				/* Copy the rest of the data over */
				memcpy(pszPending, pszData, pendingsize);
				pszData += pendingsize;
				size -= pendingsize;

				/* Reset our pending data pointer */
				pszPending = szPendingData;

				switch (status)
				{
				case eGettingMsg: /* We are trying to get the message ID and size */
					msg = *(int*)szPendingData;
					pendingsize = *(int*)(szPendingData+4);
					status = eGettingData;

					/* Need some measure of robustness */
					if (pendingsize > 2048)
					{
						closesocket(s);
						return THREAD_FAILED;
					}
					else if (pendingsize == 0)
					{
						switch (msg)
						{
							case GLAG_MSG_CLEAR:
								gfx_clear();
								break;
						}
						status = eGettingMsg;
						pendingsize = 8;
					}
					break;

				case eGettingData: /* We are trying to get data */
					switch (msg)
					{
					case GLAG_MSG_CONSOLE:
						console_handle_msg((const char*)szPendingData);
						break;
					case GLAG_MSG_FUNC:
						gfx_addcommand((void*)szPendingData, pendingsize);
						break;
					case GLAG_MSG_SHUTDOWN:
						/* TODO: Password protection */
						//exit(0);
						break;
					}
					status = eGettingMsg; /* Wait for next header */
					pendingsize = 8;
					break;
				}
			}
		}
	}
	closesocket(s);
	return 0;
}

/* Thread used to listen for client connections */
#ifdef WIN32
DWORD WINAPI ListenThread(LPVOID lpParam)
#else
#ifdef unix
void* ListenThread(void* lpParam)
#endif
#endif
{
	struct sockaddr_in sin;
	
	g_sListen = socket(AF_INET, SOCK_STREAM, 0);
	if (g_sListen == INVALID_SOCKET)
		return THREAD_FAILED;

	sin.sin_family=PF_INET;
	sin.sin_port=htons(g_wPort);
	sin.sin_addr.s_addr=INADDR_ANY;
	if(bind(g_sListen,(struct sockaddr*)&sin,sizeof(struct sockaddr))==SOCKET_ERROR)
	{
		closesocket(g_sListen);
		return THREAD_FAILED;
	}
	while (listen(g_sListen,SOMAXCONN) != SOCKET_ERROR)
	{
		int s = accept(g_sListen, 0, 0);
    if (s != INVALID_SOCKET)
    {
#ifdef WIN32
  		unsigned long dwID;
  		if (!CreateThread(NULL, 0, MessageThread, (void*)s, 0, &dwID))
  		{
  			closesocket(s);
  		}
#else
#ifdef unix
      pthread_t id;
      pthread_create(&id, NULL, MessageThread, (void*)s);
#endif
#endif
    }
	}
	closesocket(g_sListen);
	g_sListen = INVALID_SOCKET;
	return 0;
}

int msg_init(int argc, char **argv)
{
	/* Initialize sockets */
#ifdef WIN32
	WSADATA wsad;
    if(WSAStartup(0x0101,&wsad))
    {
		return -1;
	}
#endif

	/* Handle arguments */
	for (int i=1; i < argc; i++)
	{
		if (!strncmp(argv[i], "-port", strlen("-port")))
		{
			g_wPort = atoi(argv[i] + strlen("-port"));
		}
	}

	/* Create our listen thread */
#ifdef WIN32
	unsigned long dwID, dwParam = 0;
	if (!CreateThread(NULL, 0, ListenThread, &dwParam, 0, &dwID))
		return -1;
#else
#ifdef unix
  pthread_t id;
  pthread_create(&id, NULL, ListenThread, NULL);
#endif
#endif
	return 0;
}
